<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]><xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler"	>
	
	<!-- criminalDisclosureDrp templates -->
	
<xsl:template name="criminalDisclosureDrp" >  
<xsl:for-each select="n2:drpInfo/ns4:criminalDisclosure/ns4:criminalDrp">
<link href="css/MAI_print.css" rel="stylesheet" type="text/css" />
<div id="maiDRPcrim">
  <div class="content">
    <h1><u>CRIMINAL ACTION DISCLOSURE REPORTING PAGE (MA-I)</u></h1>
    <h1>CRIMINAL ACTION DRP – PART 1</h1>
    <p>This <b>Disclosure Reporting Page (DRP MA-I)</b> is an <span
						class="label">
						<xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:reponseType/m1:add)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<b>INITIAL</b> or
						<xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:reponseType/m1:amend) &gt; 0">
								
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<b>AMENDED</b> response to report details for affirmative response(s) to <b><em>Question(s)  6A and 6B</em></b> on Form MA-I.
					</span></p>
    <p>Check the question(s) to which this DRP pertains:</p>
	<div class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="formTable3" style="margin-left:0; margin-right:0;">         
          <div style="margin-left:0; margin-right:0;">
          <div class="columnStyle label1_0" style="margin-left:0; margin-right:0;">
          	
						    <xsl:choose>
							<xsl:when
								test="ns4:criminalQuestions='6A(1)(a)'">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<strong>6A(1)(a)</strong>
						<xsl:choose>
							<xsl:when
								test="ns4:criminalQuestions='6A(1)(b)'">
								
										<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<strong>6A(1)(b)</strong>
						<xsl:choose>
							<xsl:when
								test="ns4:criminalQuestions='6A(2)(a)'">
								
										<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<strong>6A(2)(a)</strong>
						<xsl:choose>
							<xsl:when
								test="ns4:criminalQuestions='6A(2)(b)'">
								
										<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						 <strong>6A(2)(b)</strong>
					
           </div>
          </div>
              <div style="margin-left:0; margin-right:0;">
          <div class="columnStyle label1_0" style="margin-left:0; margin-right:0;">
          	
						    <xsl:choose>
							<xsl:when
								test="ns4:criminalQuestions='6B(1)(a)'">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<strong>6B(1)(a)</strong>
						<xsl:choose>
							<xsl:when
								test="ns4:criminalQuestions='6B(1)(b)'">
								
										<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<strong>6B(1)(b)</strong>
						<xsl:choose>
							<xsl:when
								test="ns4:criminalQuestions='6B(2)(a)'">
								
										<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<strong>6B(2)(a)</strong>
						<xsl:choose>
							<xsl:when
								test="ns4:criminalQuestions= '6B(2)(b)'">
								
										<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						 <strong>6B(2)(b)</strong> 

					
           </div>
          </div>
        </div>
		</div>
    
    <div class="mainDiv2" style="margin-left:0; margin-right:0;">
	<div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow noborder">
        <div class="tdStyle1 tditem10col1">Is this DRP an amendment that seeks to remove a previously filed DRP concerning the individual from the record?</div>
        <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable = 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>    
                YES<xsl:choose>
							<xsl:when
								test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable = 'N'">
										<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
							 <img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								
							</xsl:otherwise>
						</xsl:choose>    
                NO</div>
      </div>
	  <div style="clear:both"></div>
      <div>
        <div class="tdStyle1">If &quot;Yes,&quot; the reason the DRP should be removed is:</div>
	  </div>
	  <div class="tableRow">
								
        <div class="tdStyle1"><p>
          <label>
               <xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isRegistered) &gt; 0">
									 <img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
							
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>    
          </label>
The event or <em>proceeding</em> was resolved in the individual&#39;s favor<br />
    <xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isFiledError) &gt; 0">
									 <img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
							
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>    
The DRP was filed in error. </p></div>
      </div>
      <div class="tableRow">
              <div class="tdStyle1" style="margin-left:0; margin-right:0;"><br />
              Explain the circumstances:<br></br>
                                          <textarea name="textarea4" id="textarea4" cols="52" rows="5">
				
				<xsl:value-of
                       select="string(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isFiledError/m1:explainTheCircumstances)" />
     				
              </textarea></div>
      </div>
    </div>
	</div>
    <p><b><u>How to Report an Event or <em>Proceeding</em> on a Criminal Action DRP</u>:</b> Use a separate DRP for each event or <em>proceeding</em>. One event may result in more than one affirmative answer to Items <b>6A(1)(a), 6A(1)(b), 6A(2)(a), 6A(2)(b), 6B(1)(a), 6B(1)(b), 6B(2)(a), and/or 6B(2)(b).</b> Use this DRP to report all <em>charges</em>, including multiple counts of the same <em>charge,</em> arising out of the same event and filed in one criminal action. Separate cases arising out of the same event, and unrelated criminal actions, must be reported on separate DRPs.</p>
    <p><b><u>How to Provide Court Documents</u>:</b> Applicable court documents (<u>i.e.</u>, criminal complaint, information or indictment, as well as judgment of conviction or sentencing documents) must be attached as an exhibit if not previously submitted. </p>
    
	<div class="mainDiv2" style="margin-left:0; margin-right:0;">
	<div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
        <div class="tdStyle1 tditem10col1"><strong><u>DRP On File for This Event:</u></strong> <u>Is an accurate and up-to-date DRP containing the information regarding the individual required by this DRP already on file (a) in the <em>IARD</em> or <em>CRD</em> system (with a Form ADV, BD, or U4), or (b) in the <em>SEC</em>'s EDGAR system (with a Form MA or Form MA-I)?</u></div> 
        <div class="tdStyle1 tditem10col2"><label>
       
         <xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling)&gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maFiling)&gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:matFiling)&gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />Yes  Provide the applicable information indicated below that identifies where the DRP or other disclosure may be found.	<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  Provide the applicable information indicated below that identifies where the DRP or other disclosure may be found.	<img
									src="Images/radio-checked.jpg" alt="radio button checked" />No
							</xsl:otherwise>
						</xsl:choose>   
            
            </label>
            
            </div>
      </div><div style="clear:both"></div>
    </div>
	</div>
<p><u><em>Note: The filer may identify a DRP filed by the individual directly, or filed by another SEC-registrant about the individual as an associated person.</em></u></p>
<!--      <p><strong><em> Note 2: If a Form MA-T is on file that includes disclosures for this event, but does not include all the information required by this DRP, the disclosures on Form MA-T are not considered accurate and up-to-date.</em></strong></p>
    <p></p>-->
			<div class="mainDiv2" style="margin-left:0; margin-right:0;">
              <div class="formTable3" style="margin-left:0; margin-right:0;">
            <div style="margin-left:0; margin-right:0;">
             
              <div class="tdStyle1">If the answer is &quot;Yes&quot;, Provide the applicable information indicated below that identifies where the DRP may be found. </div>
            </div>
            <div class="tableRow">
            
              <div class="tdStyle1">          
              <xsl:choose>
						<xsl:when
								test="string(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:filingName)">
										
									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
									<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>   
                <label><b> 1. Form ADV, BD, or U4 Filing: For a DRP filed on the <em>IARD</em> or <em>CRD</em> system with one of these forms, provide the following information:</b></label></div>
            </div>
	  <div style="clear:both"></div>
	  <div class="tableStyle noborder" style="margin-left:0; margin-right:0;">
		  <div class="tableRow" style="margin-left:0; margin-right:0;">
			<div class="tdStyle1 tdCrmCol1"><p>Name on Registration:</p></div>
			<div class="tdStyle1 tdCrmCol2Textboxpadded">
								<xsl:value-of
									select="string(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:filingName)" />
			</div>
		  </div>
		  <div style="clear:both"></div>
		  <div class="tableRow">
			<div class="tdStyle1 tdCrmCol1"><p><em>CRD</em> No.:</p></div>
		   <div class="tdStyle1 tdCrmCol2Textboxpadded">
								<xsl:value-of
									select="string(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:crdNumber)" />
								 </div>
		  </div>
		  <div style="clear:both"></div>
		  <div class="tableRow">
			<div class="tdStyle1 tdCrmCol1"><p>Disclosure Occurrence No.:</p></div>
			<div class="tdStyle1 tdCrmCol2Textboxpadded">
								<xsl:value-of
									select="string(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:disclosureNumber)" />
								 </div>
		  </div> 
		  <div style="clear:both"></div>
	  </div>
      <div class="tableRow">
             
              <div class="tdStyle1">          
              <xsl:choose>
						<xsl:when
								test="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingName)">
										
									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>   
                <b>2. Form MA Filing: </b> For a DRP filed on EDGAR with a Form MA, provide the following information:</div>
            </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Name on Registration:</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingName)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>MA Registration Number:</p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:registrationNumber)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Date of filing that contains the DRP (MM/DD/YYYY):</p></div>
      <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingDate)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Accession number of the filing: </p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:accessionNumber)" />
						 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
             
              <div class="tdStyle1">
                     <xsl:choose>
						<xsl:when
								test="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingName)">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>   
                 <b>3. Form MA-I Filing:</b> For a DRP filed on EDGAR with a Form MA-I, provide the following information:</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Name of Individual:</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingName)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>MA-I File Number:</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:registrationNumber)" />
						 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Date of filing that contains the DRP (MM/DD/YYYY):</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingDate)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Accession number of the filing:</p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:accessionNumber)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <!--  
            <tr>
              
              <td class="checkbox">          <xsl:choose>
						<xsl:when
								test=" count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 ">
										<img
									src="Imagesbox-checked.jpg" />
							</xsl:when>
							<xsl:otherwise>
							<img
									src="Images/box-unchecked.jpg" />
									
							</xsl:otherwise>
						</xsl:choose>   
                <label> <b>4. Form MA-T Filing:</b> For a disclosure filed on the <em>SEC</em> website with a Form MA-T, provide the following information identifying the disclosure on the <em>SEC</em> website at: <a href="https://tts.sec.gov/MATR/index.html">https://tts.sec.gov/MATR/index.html</a>:</label></td>
            </tr>
                  <tr>
        <td class="label"><p>Name on Registration: </p></td>
        <td class="value">
							<xsl:value-of
								select="string(ns4:baseHeader/ns4:filingInfo/ns4:matFiling/ns4:filingName)" />
						 </td>
      </tr>
      <tr>
        <td class="label"><p>MA-T Registration Number: </p></td>
       <td class="value">
							<xsl:value-of
								select="string(ns4:baseHeader/ns4:filingInfo/ns4:matFiling/ns4:registrationNumber)" />
							 </td>
      </tr>
      <tr>
        <td class="label"><p>Date of filing that contains the disclosure (MM/DD/YYYY):</p></td>
       <td class="value">
							<xsl:value-of
								select="string(ns4:baseHeader/ns4:filingInfo/ns4:matFiling/ns4:filingDate)" />
							 </td>
      </tr>-->
            </div>
			</div>
    <p class="guidance"><b>NOTE: The completion of all or any part of this form does not relieve the individual or any <em>municipal advisor</em> with which the individual is associated of the obligation to update any relevant Form MA or <em>IARD</em> or <em>CRD</em> records.</b></p>
    <h1>CRIMINAL ACTION DRP – PART 2</h1>
    <p><b>1. Firm or Organization</b></p>
    
	<div class="mainDiv2" style="margin-left:0; margin-right:0;">
	<div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
        <div class="tdStyle1 tditem10col1"><p><b>A. Were <em>charge(s)</em> brought against a firm or organization over which the individual exercise(d) <em>control</em>?</b></p></div>
        <div class="tdStyle1 tditem10col2">
               <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:chargeInfo/ns4:name)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />YES	<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
							</xsl:when>
							<xsl:when
								test="count(ns4:drpData/ns4:chargeInfo)&gt; 0 and not(count(ns4:drpData/ns4:chargeInfo/ns4:name)&gt; 0) ">
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES	<img
									src="Images/radio-checked.jpg" alt="radio button checked" />NO
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES	<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
							</xsl:otherwise>
						</xsl:choose>   
            </div>
      </div></div>
	  </div>
      
	<div class="mainDiv2" style="margin-left:0; margin-right:0;">
	 <div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
        <div class="tdStyle1"><p><b>B. If &quot;Yes,&quot; Provide the following information:</b></p></div>
        <div style="margin-left:0; margin-right:0;"></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>(1) Enter the firm or organization name: </p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:chargeInfo/ns4:name)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
	  </div>
	  </div>
      
      <div class="mainDiv2" style="margin-left:0; margin-right:0;">
	  <div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>(2) Was the firm or organization engaged in a <em>municipal advisor-related</em> or <em>investment-related</em> business? </p></div>
        <div class="tdStyle1 tdCrmCol2">
          <xsl:choose>
							<xsl:when
								test="ns4:drpData/ns4:chargeInfo/ns4:isEngagedInMARBusiness ='Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />YES	<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
							</xsl:when>
							<xsl:when
								test="ns4:drpData/ns4:chargeInfo/ns4:isEngagedInMARBusiness ='N'">
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES	<img
									src="Images/radio-checked.jpg" alt="radio button checked" />NO
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES	<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
							</xsl:otherwise>
						</xsl:choose>   </div>
      </div>
	  <div style="clear:both"></div>
	  </div>
	  </div>
      
	  <div class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>(3) What was the individual&#39;s position, title or relationship with the firm or organization?</p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:chargeInfo/ns4:relationshipToCharged)" />
							 </div>
      </div></div>
	  </div>
	  
	  <div class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="formTable3" style="margin-left:0; margin-right:0;">
							
      <div class="tableRow">
        <div class="tdStyle1"><b>2. Court Where Formal <em>Charge(s)</em> Were Brought: <em>(File a separate Criminal Action DRP for charges brought in separate courts and / or separate cases in the same court. If brought in a foreign jurisdiction, provide all the information below in English.)</em>:</b></div></div>
          </div>
		  </div>
		  
	<div class="mainDiv2" style="margin-left:0; margin-right:0;">	  
      <div class="formTable3" style="margin-left:0; margin-right:0;">
											
      <div style="margin-left:0; margin-right:0;">  <div colspan="2" class="label1_0" style="margin-left:0; margin-right:0;">    <b>
            <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:formalCharges/ns4:courtType/ns4:isFederalCourt)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
        </b>          Federal Court <br />
                <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:formalCharges/ns4:courtType/ns4:isMilitaryCourt)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
          Military Court <br />
                 <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:formalCharges/ns4:courtType/ns4:isStateCourt)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
          State Court <br />
                <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:formalCharges/ns4:courtType/ns4:isForeignCountryCourt)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
          Foreign Country Court <br />
                <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:formalCharges/ns4:courtType/ns4:isInternationalCourt)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
          International Court <br />
                <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:formalCharges/ns4:courtType/ns4:isOther)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
          Other:
                    <br>(specify)</br>
               <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:formalCharges/ns4:courtType/ns4:isOther)&gt; 0">
							<xsl:value-of
								select="string(ns4:drpData/ns4:formalCharges/ns4:other)" />
						</xsl:when>
							<xsl:otherwise>
							<input 	type="text" 	name="input21" 	readonly="1"></input>
						</xsl:otherwise>
						</xsl:choose>  
         </div>
      </div>
      </div>
	  </div>
      
	  <div class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p><b>A. Name of the Court:</b></p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:formalCharges/ns4:chargesInfo/ns4:courtInfo/m1:name)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p><b>B. Location of the Court:</b></p></div>
        <div style="margin-left:0; margin-right:0;"></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>    Street Address: </p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:formalCharges/ns4:chargesInfo/ns4:courtInfo/m1:address/ns1:street1)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>    City or County: </p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:formalCharges/ns4:chargesInfo/ns4:courtInfo/m1:address/ns1:city)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>    State / Country: </p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:formalCharges/ns4:chargesInfo/ns4:courtInfo/m1:address/ns1:stateOrCountry)" />
						 </div>
      </div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>    Postal Code: </p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:formalCharges/ns4:chargesInfo/ns4:courtInfo/m1:address/ns1:zipCode)" />
						 </div>
      </div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p><b>C. Docket / Case Name: </b></p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded" >
							<xsl:value-of
								select="string(ns4:drpData/ns4:formalCharges/ns4:chargesInfo/ns4:docketCaseName)" />
						 </div>
      </div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p><b>D. Docket / Case Number: </b></p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:formalCharges/ns4:chargesInfo/ns4:courtInfo/m1:docketOrCaseNo)" />
							 
						 </div>
      </div></div>
	  </div>
      
	  <div class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
        <div class="tdStyle1"><b>3. Event Disclosure Detail</b> (Use this for both organizational and individual <em>charges</em>.)</div>
        <div style="margin-left:0; margin-right:0;"></div>
      </div></div>
      </div>
	  
	  <div class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
       <div class="tdStyle1 tdCrmCol1"><p>    <b>A. Date First <em>Charged </em></b>(MM/DD/YYYY):</p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:eventDisclosureDetail/ns4:eventDetail/m1:date)" />
		</div>
	   </div>
       <div style="margin-left:0; margin-right:0;">
			<div class="tdStyle1">				 
          <label>
             <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:eventDisclosureDetail/ns4:eventDetail/m1:exact)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
            Exact </label>
          
          <label>
           <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:eventDisclosureDetail/ns4:eventDetail/m1:explanationInfo)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
            Explanation</label></div>
      </div></div>
	  </div>
      
	  <div class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>      If not exact, provide explanation:</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
        
             <xsl:value-of
								select="string(ns4:drpData/ns4:eventDisclosureDetail/ns4:eventDetail/m1:explanationInfo/m1:provideExplanation)" />
        </div>
      </div></div>
	  </div>
      
	  <div class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="formTable3" style="margin-left:0; margin-right:0;">
      <div>
        <div class="tdStyle1"><p><b>    B. Details of Event:</b> Report all <em>charges</em> separately. </p>
        <p>For each <em>charge,</em> provide the following information.</p>
         </div>
        <div style="margin-left:0; margin-right:0;"></div>
      </div></div>
	  </div>
      <xsl:for-each select="ns4:drpData/ns4:eventDisclosureDetail/ns4:chargeDetails/ns4:chargeDetail"> 
      <p><b>        (1) First <em>Charge</em></b> </p>
      
	  <div class="mainDiv2" style="margin-left:0; margin-right:0;">
	  <div class="formTable3" style="margin-left:0; margin-right:0;">							
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        (a) List the <em>charge</em> / <em>charge</em> description:</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
             <xsl:value-of
								select="string(ns4:charge)" />
        </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        (b) Number of counts: </p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:numberOfCounts)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        (c) Check the appropriate box: </p></div>
        <div class="tdStyle1 tdCrmCol2">
          <xsl:choose>
							<xsl:when
								test="count(ns4:felonyOrMisdemeanor/m1:felony)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
          <em>Felony</em> 
         <xsl:choose>
							<xsl:when
								test="count(ns4:felonyOrMisdemeanor/m1:misdemeanor)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
          <em>Misdemeanor</em></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        (d) Plea for this <em>charge</em>:</p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:plea)" />
						 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        (e) (i) Is the <em>charge municipal advisor-related? </em></p></div>
        <div class="tdStyle1 tdCrmCol2">
             <xsl:choose>
							<xsl:when
								test="count(ns4:productType)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
            Yes
          
            <xsl:choose>
							<xsl:when
								test="count(ns4:productType)&gt; 0">
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:otherwise>
						</xsl:choose>  
            No</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>             (ii) If &quot;Yes,&quot; what is the product type?</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:productType)" />
							 </div>
      </div>
	   <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        (f) (i) Is the <em>charge investment-related?</em></p></div>
        <div class="tdStyle1 tdCrmCol2">
             <xsl:choose>
							<xsl:when
								test="count(ns4:investmentProductType)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
            Yes
          
            <xsl:choose>
							<xsl:when
								test="count(ns4:investmentProductType)&gt; 0">
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:otherwise>
						</xsl:choose>  
            No</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            (ii) If &quot;Yes,&quot; what is the product type?</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:investmentProductType)" />
							 </div>
      </div></div>
	  </div>
      
      <div class="mainDiv2" style="margin-left:0; margin-right:0;">
	  <div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        (g) (i) Amended <em>Charge</em>: Indicate if the original <em>charge</em> was amended or reduced:</p></div>
        <div class="tdStyle1 tdCrmCol2">
             <xsl:choose>
							<xsl:when
								test="count(ns4:amendedReducedDate)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
            Yes
            <xsl:choose>
							<xsl:when
								test="count(ns4:amendedReducedDate)&gt; 0">
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:otherwise>
						</xsl:choose>  
            No</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            (ii) If &quot;Yes,&quot; provide the date the <em>charge</em> was amended or reduced: </p></div>
      <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:amendedReducedDate)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
     </div>
     </div>
	 
    </xsl:for-each>
		  
	 <div class="mainDiv2" style="margin-left:0; margin-right:0;">
	 <div class="formTable3" style="margin-left:0; margin-right:0;">
						
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1">
          <p class="minutia"><b>    C. <em>Felony</em> <em>Charge(s)</em>:</b> Did any of the <em>charge</em>(s) within the event <em>involve</em> a <em>felony</em>? </p></div>
        <div class="tdStyle1 tdCrmCol2">
        <xsl:choose>
				<xsl:when
					test="ns4:drpData/ns4:appealInformation/ns4:isFelonyCharge = 'Y'">
					<img src="Images/radio-checked.jpg" alt="radio button checked" />
					Yes
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					No
				</xsl:when>
				<xsl:when
					test="ns4:drpData/ns4:appealInformation/ns4:isFelonyCharge = 'N'">
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					Yes
					<img src="Images/radio-checked.jpg" alt="radio button checked" />
					No
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					Yes
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					No
				</xsl:otherwise>
			</xsl:choose>
        </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><b>4. Current Status of the Event:</b>  </div>
        <div class="tdStyle1 tdCrmCol2"><label> <xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:status/ns3:pending)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
        Pending</label>
       
         <label>  <xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:status/ns3:onAppeal)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
        On Appeal</label>
       
        <label> <xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:status/ns3:final)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
        Final</label></div>
      </div>
	  <div style="clear:both"></div>
	  </div>
	  </div>
     
	<div class="mainDiv2" style="margin-left:0; margin-right:0;">						
							<div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow">  
	  <div class="tdStyle1 tdCrmCol1">
          <b>5. Event Status Date </b>(Complete unless status is pending) (MM/DD/YYYY):</div>
        <div class="tdStyle1 tdCrmCol2"> 
             <input 	type="text" 	name="input36" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:drpData/ns4:appealInformation/ns4:eventStatusDate/m1:date)" />
							</xsl:attribute>
						</input>
            <label>
               <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:appealInformation/ns4:eventStatusDate/m1:exact)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
              Exact </label>
            
            <label>
               <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:appealInformation/ns4:eventStatusDate/m1:explanationInfo)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
              Explanation</label>
         </div>
		 <div style="clear:both"></div>
      </div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>    If not exact, provide explanation:</p></div>
         <div class="tdStyle1 tdCrmCol2Textboxpadded"> 
            <xsl:value-of select="string(ns4:drpData/ns4:appealInformation/ns4:eventStatusDate/m1:explanationInfo/m1:provideExplanation)" />
				 </div>
      </div>
	  <div style="clear:both"></div>
	  </div>
	  </div>
      
       <div class="mainDiv2" style="margin-left:0; margin-right:0;">
	   <div class="formTable3" style="margin-left:0; margin-right:0;">
      <div>
        <div class="tdStyle1"><b>6. On Appeal – Judicial Review</b>: <b>If you checked &quot;On Appeal&quot; in Item 4, to whom was the criminal action appealed? (<em>If brought in a foreign jurisdiction, provide all the information below in English):</em></b></div>
        </div>
        </div></div>
      
       <div class="mainDiv2" style="margin-left:0; margin-right:0;">
	   <div class="formTable3" style="margin-left:0; margin-right:0;">
        <div class="tableRow">
								
          <div class="tdStyle1">    <b>
            <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:courtType[m1:court = 'Federal Court'])&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
        </b>          Federal Court <br />
                 <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:courtType[m1:court = 'Military Court'])&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
          Military Court <br />
                 <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:courtType[m1:court = 'State Court'])&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
          State Court <br />
                <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:courtType[m1:court = 'Foreign Country Court'])&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
          Foreign Country Court <br />
                <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:courtType[m1:court = 'International Court'])&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
          International Court <br />
          </div>
		  </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
          	<div class="tdStyle1 tdCrmCol1">
                <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:courtType[m1:court = 'Other'])&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>  
          Other: (specify)
          </div>
          <div class="tdStyle1 tdCrmCol2Textboxpadded">
          				<xsl:value-of
								select="string(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:courtType/m1:other)" /> 
         </div>
      </div>
	  <div style="clear:both"></div>

       <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p><b>    A. Name of the Court: </b></p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:chargesInfo/ns4:courtInfo/m1:name)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1" ><p><b>    B. Location of the Court:</b></p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        Street Address: </p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:chargesInfo/ns4:courtInfo/m1:address/ns1:street1)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        City or County: </p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:chargesInfo/ns4:courtInfo/m1:address/ns1:city)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        State / Country: </p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:chargesInfo/ns4:courtInfo/m1:address/ns1:stateOrCountry)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        Postal Code: </p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:chargesInfo/ns4:courtInfo/m1:address/ns1:zipCode)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p><b>    C. Docket / Case Name: </b></p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:chargesInfo/ns4:docketCaseName)" />
						 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p><b>    D. Docket / Case Number: </b></p></div>
      <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:appealInformation/ns4:courtInfo/ns4:chargesInfo/ns4:courtInfo/m1:docketOrCaseNo)" />
							 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p><b>    E. Date Appeal filed</b> (MM/DD/YYYY):</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
							<xsl:value-of
								select="string(ns4:drpData/ns4:appealInformation/ns4:dateAppealFiled)" />
							 </div>
      </div>
    </div> </div>
    <p> <b>For Item 7: If you checked &quot;Final&quot; or &quot;On Appeal&quot; in Item 4, complete Item 7.
      For actions that are &quot;Pending,&quot; skip to Item 8.</b></p>
    <p><b>7. Disposition Disclosure Detail (For each <em>charge</em>, provide the following information):</b></p>
   
      
       <xsl:for-each select="ns4:drpData/ns4:appealInformation/ns4:dispositionDetails/ns4:dispositionDetail">
      <div class="mainDiv2" style="margin-left:0; margin-right:0;">
	  <div class="formTable3" style="margin-left:0; margin-right:0;">						
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1" style="margin-left:0; margin-right:0;"><p><b>(a) First<em> Charge</em></b></p></div>
        <div style="margin-left:0; margin-right:0;"></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1"><b>    (1) Disposition of the <em>Charge:</em></b>
          <p class="minutia">       Check all that apply.</p></div>
	  </div>
	  <div style="clear:both"></div>
	  <div>
										
        <div colspan="2" style="margin-left:0; margin-right:0;">

          <div class="mainDiv2" style="margin: 5px 0;">
          <div class="formTable3" style="margin-left:0; margin-right:0;">
<div class="tableRow">
	<div class="tdStyle1 td3cols">         <xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Acquitted'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>  Acquitted</div>
	<div class="tdStyle1 td3cols"><xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Found not guilty'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>   <em>Found</em> not guilty</div>
						<div class="tdStyle1 td3cols"><xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Pre-trial diversion/intervention'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Pre-trial diversion/intervention</div>
	</div>
	<div style="clear:both"></div>
						
	<div class="tableRow">
		<div class="tdStyle1 td3cols">         <xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Amended'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Amended</div>
		<div class="tdStyle1 td3cols"><xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Pled guilty'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Pled guilty</div>
		<div class="tdStyle1 td3cols"><xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Reduced'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Reduced</div></div>
	<div style="clear:both"></div>
	<div class="tableRow">
		<div class="tdStyle1 td3cols">         <xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Convicted'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Convicted</div>
		<div class="tdStyle1 td3cols"><xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Pled nolo contendere'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Pled nolo contendere</div>
						<div rowspan="2" class="tdStyle1 td3cols"><xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Other'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Other (requires explanation) <br/>
						    </div>
	</div>
	<div style="clear:both"></div>
	
	<div class="tableRow">
	<div class="tdStyle1 td3cols">         <xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Deferred Adjudication'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Deferred Adjudication</div>
		<div class="tdStyle1 td3cols"><xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Pled not guilty'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Pled not guilty</div>
	</div>
	<div style="clear:both"></div>
	<div class="tableRow">
	<div class="tdStyle1 td3cols">         <xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Dismissed'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Dismissed</div>
	</div>
	<div style="clear:both"></div>
						
	<div class="tableRow">
	<div class="tdStyle1 td3cols">         <xsl:choose>
						<xsl:when
								test="count(ns4:dispositionType[ns4:type='Appealed'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Appealed   </div>
	</div>
	<div style="clear:both"></div>
	<div class="tableRow">
			<div style="margin-left:0; margin-right:0;">   
			<div class="mainDiv2" style="margin: 5px 0px 5px 5px; width:99%;">
			<div class="formTable3" style="margin-left:0; margin-right:0;">
					
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1">                  
							<xsl:choose>
							<xsl:when
									test="count(ns4:dispositionType[ns4:appealType='Affirmed'])&gt; 0 and count(ns4:dispositionType[ns4:type='Appealed'])&gt; 0">

										<img
										src="Images/box-checked.jpg" alt="checkbox checked" />
								</xsl:when>
								<xsl:otherwise>
							
									<img
										src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
								</xsl:otherwise>
							</xsl:choose> Affirmed   </div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1">                  
							<xsl:choose>
							<xsl:when
								test="count(ns4:dispositionType[ns4:appealType='Vacated &amp; Returned For Further Action'])&gt; 0 and count(ns4:dispositionType[ns4:type='Appealed'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
							</xsl:choose> Vacated &amp; Returned For Further Action   </div>
						</div>
						<div style="clear:both"></div>
						
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1">                  
							<xsl:choose>
							<xsl:when
								test="count(ns4:dispositionType[ns4:appealType='Vacated / Final'])&gt; 0 and count(ns4:dispositionType[ns4:type='Appealed'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
							</xsl:choose> Vacated/Final 
							</div>
						</div>
						<div style="clear:both"></div>
						
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1">                  
							<xsl:choose>
							<xsl:when
								test="count(ns4:dispositionType[ns4:appealType='Other'])&gt; 0 and count(ns4:dispositionType[ns4:type='Appealed'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
							</xsl:choose> Other (requires explanation)  
							</div>
						</div>
						<div style="clear:both"></div>
											
				</div>
				</div>
			
			</div>
			
		</div>
		<div style="clear:both"></div>
	
        </div>
		</div>
          </div>
      </div>
      </div></div>
	  
	  <div class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="formTable3" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        Explanation: </p>
          <p class="minutia">        <em>If more than one disposition is checked, and/or &quot;Other&quot; is checked, or the above otherwise does not adequately summarize the disposition of the charge, provide an explanation.</em> </p>
		</div>							
        <div class="tdStyle1 tdCrmCol2Textboxpadded"><xsl:value-of
								select="string(ns4:dispositionType/ns4:explanation)" />
        </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><b>    (2) Date (MM/DD/YYYY): </b></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">       <input 	type="text" 	name="input48" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:date)" />
							</xsl:attribute>
						</input></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><b>    (3) Sentence / Penalty: Is a sentence or other penalty ordered? </b></div>
        <div class="tdStyle1 tdCrmCol2">
        <xsl:choose>
						<xsl:when
								test="count(ns4:sentencePenaltyType)&gt; 0">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>Yes 
			<xsl:choose>
						<xsl:when
								test="count(ns4:sentencePenaltyType)&gt; 0">
								<img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:when>
							<xsl:otherwise>
						 <img src="Images/radio-checked.jpg" alt="radio button checked" />
								
							</xsl:otherwise>
						</xsl:choose> No 
            </div>
      </div>
	  <div style="clear:both"></div>
      
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        If &quot;Yes,&quot; list each type (<em>e.g.</em> prison, jail, probation, community service, counseling, education, other - specify):</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded"> 
			<xsl:value-of 				select="string(ns4:sentencePenaltyType)" />
        </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><b>    (4) Was or is the individual incarcerated in connection with this sentence?</b></div>
        <div class="tdStyle1 tdCrmCol2">  <xsl:choose>
						<xsl:when
								test="count(ns4:incarcerationInfo)&gt; 0">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>Yes 
 
<xsl:choose>
						<xsl:when
								test="count(ns4:incarcerationInfo)&gt; 0">
			<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:when>
							<xsl:otherwise>
						 <img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								
							</xsl:otherwise>
						</xsl:choose>
 No </div>
      </div>
	  <div style="clear:both"></div>
	  <div class="tableRow">
		<div class="tdStyle1 tdCrmCol1"><p>        If &quot;Yes,&quot; provide the following details:</p></div>
	  </div>
	  <div style="clear:both"></div>
      <div style="margin-left:0; margin-right:0;"></div>
      <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        (i) Duration (length of the sentence):</p></div>
        <div style="margin-left:0; margin-right:0;"></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            Days</p></div>
        <div class="tdStyle1 tdCrmCol2"> <input 	type="text" 	name="input49" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:incarcerationInfo/ns4:duration/m1:days)" />
							</xsl:attribute>
						</input></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            Months</p></div>
        <div class="tdStyle1 tdCrmCol2"> <input 	type="text" 	name="input50" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:incarcerationInfo/ns4:duration/m1:months)" />
							</xsl:attribute>
						</input></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            Years</p></div>
        <div class="tdStyle1 tdCrmCol2"> <input 	type="text" 	name="input51" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:incarcerationInfo/ns4:duration/m1:years)" />
							</xsl:attribute>
						</input></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        (ii) Start Date of Penalty (MM/DD/YYYY): </p></div>
        <div class="tdStyle1"> <input 	type="text" 	name="input52" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:incarcerationInfo/ns4:startDate/m1:date)" />
							</xsl:attribute>
						</input>
          <xsl:choose>
						<xsl:when
								test="count(ns4:incarcerationInfo/ns4:startDate/m1:notDetermined)&gt; 0">
				 <img
									src="Images/box-checked.jpg" alt="checkbox checked" />
									
							</xsl:when>
							<xsl:otherwise>
						<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
								
							</xsl:otherwise>
						</xsl:choose>
          Not determined. </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        (iii) End Date of Penalty (MM/DD/YYYY): </p></div>
        <div class="tdStyle1">  <input 	type="text" 	name="input53" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:incarcerationInfo/ns4:endDate/m1:date)" />
							</xsl:attribute>
						</input>
         <xsl:choose>
						<xsl:when
								test="count(ns4:incarcerationInfo/ns4:endDate/m1:notDetermined)&gt; 0">
	
									 <img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						 		<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
								
							</xsl:otherwise>
						</xsl:choose>
          Not determined.</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>        (iv) Is the sentence to be served concurrently with any other sentence? </p></div>
        <div class="tdStyle1 tdCrmCol2"> <xsl:choose>
						<xsl:when
								test="count(ns4:incarcerationInfo/ns4:concurrentEndDate)&gt; 0">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>Yes 
 
<xsl:choose>
						<xsl:when
								test="count(ns4:incarcerationInfo/ns4:concurrentEndDate)&gt; 0">
			<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:when>
							<xsl:otherwise>
						 <img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								
							</xsl:otherwise>
						</xsl:choose>
 No</div>
      </div>   
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            If &quot;Yes,&quot; indicate the end date of the concurrent sentence (MM/DD/YYYY): </p></div>
        <div class="tdStyle1 tdCrmCol2">  <input 	type="text" 	name="input55" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:incarcerationInfo/ns4:concurrentEndDate)" />
							</xsl:attribute>
						</input></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            (v) Explanation (Optional): </p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
			<xsl:value-of
								select="string(ns4:incarcerationInfo/ns4:explanation)" />        
        </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><b>      (5) Monetary Penalty / Fine:</b></div>
        <div></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            (i) Was a monetary penalty/fine imposed?</p></div>
        <div class="tdStyle1 tdCrmCol2"><xsl:choose>
						<xsl:when
								test="count(ns4:monetaryPenalty)&gt; 0">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>Yes 
 
<xsl:choose>
						<xsl:when
								test="count(ns4:monetaryPenalty)&gt; 0">
			<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:when>
							<xsl:otherwise>
						 <img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								
							</xsl:otherwise>
						</xsl:choose>
 No</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            If &quot;Yes,&quot; provide the following details in (ii) and (iii) below:</p></div>
        <div></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            (ii) Total Penalty/Fine Amount:$ </p></div>
        <div class="tdStyle1 tdCrmCol2">
        <xsl:call-template name="format_to_dollar">
              <xsl:with-param name="money" select="string(ns4:monetaryPenalty/ns4:totalFine)" />
        </xsl:call-template>
        <!-- 
        <input 	type="text" 	name="input56" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:monetaryPenalty/ns4:totalFine)" />
							</xsl:attribute>
						</input>
		-->
						</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            (iii) Was any portion suspended/reduced?</p></div>
        <div class="tdStyle1 tdCrmCol2"><xsl:choose>
						<xsl:when
								test="count(ns4:monetaryPenalty/ns4:reducedAmount)&gt; 0">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>Yes 
 
<xsl:choose>
						<xsl:when
								test="count(ns4:monetaryPenalty/ns4:reducedAmount)&gt; 0">
			<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:when>
							<xsl:otherwise>
						 <img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								
							</xsl:otherwise>
						</xsl:choose>
 No</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>                If &quot;Yes,&quot; how much? $ </p></div>
        <div class="tdStyle1 tdCrmCol2">
        <xsl:call-template name="format_to_dollar">
              <xsl:with-param name="money" select="string(ns4:monetaryPenalty/ns4:reducedAmount)" />
        </xsl:call-template>
        <!-- 
        <input 	type="text" 	name="input57" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:monetaryPenalty/ns4:reducedAmount)" />
							</xsl:attribute>
						</input>
						-->
						</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            (iv) Final Amount: </p></div>
        <div class="tdStyle1 tdCrmCol2">
         <xsl:call-template name="format_to_dollar">
              <xsl:with-param name="money" select="string(ns4:monetaryPenalty/ns4:finalAmount)" />
        </xsl:call-template>
        <!-- 
        <input 	type="text" 	name="input58" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:monetaryPenalty/ns4:finalAmount)" />
							</xsl:attribute>
						</input>
		-->
						</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>            (v) Was the final amount paid in full? </p></div>
       <div class="tdStyle1 tdCrmCol2"><xsl:choose>
						<xsl:when
								test="count(ns4:monetaryPenalty/ns4:paidStatus/ns4:paidInFullDate)&gt; 0">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>Yes 
 
<xsl:choose>
						<xsl:when
								test="count(ns4:monetaryPenalty/ns4:paidStatus/ns4:paidInFullDate)&gt; 0">
			<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:when>
							<xsl:otherwise>
						 <img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								
							</xsl:otherwise>
						</xsl:choose>
 No</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>                If &quot;Yes,&quot; date paid in full (MM/DD/YYYY):</p></div>
        <div class="tdStyle1 tdCrmCol2"><input 	type="text" 	name="input59" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:monetaryPenalty/ns4:paidStatus/ns4:paidInFullDate)" />
							</xsl:attribute>
						</input></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>               <b>If &quot;No,&quot; indicate the amount unpaid:</b> </p></div>
        <div class="tdStyle1 tdCrmCol2">
        <xsl:call-template name="format_to_dollar">
              <xsl:with-param name="money" select="string(ns4:monetaryPenalty/ns4:paidStatus/ns4:notPaidInfo/ns4:amountUNPAID)" />
        </xsl:call-template>
        <!-- 
        <input 	type="text" 	name="input60" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns4:monetaryPenalty/ns4:paidStatus/ns4:notPaidInfo/ns4:amountUNPAID)" />
							</xsl:attribute>
						</input>
		-->
						</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>                And explain the circumstances:</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded"> 
         
            	<xsl:value-of
								select="string(ns4:monetaryPenalty/ns4:paidStatus/ns4:notPaidInfo/ns4:explanation)" />
        </div>
      </div>
 
  </div></div>
   </xsl:for-each>
   
   <div class="mainDiv2" style="margin-left:0; margin-right:0;">
  <div class="formTable3" style="margin-left:0; margin-right:0;">
		
      <div class="tableRow">
        <div class="tdStyle1"><b>8. Summary of Circumstances (Optional):</b> You may use this space to provide a brief summary of circumstances 
		leading to the <em>charge</em>(s), as well as the current status or final disposition, if any. Include the relevant dates when the conduct which 
		was the subject of the <em>charge</em>(s) occurred, and any other relevant information. The information must fit within the space provided.
		</div></div></div> <p/>
	
	<div class="formTable3" style="margin-left:0; margin-right:0;">	
		<div style="margin-left:0; margin-right:0;">
											
        <div class="value2" style="margin-left:0; margin-right:0;"> 
                             <xsl:value-of
								select="string(ns4:baseHeader/ns4:summary)" />
        </div>
      </div>
    </div>
	</div>
	
  </div>
</div>
 </xsl:for-each> 
</xsl:template>

</xsl:stylesheet>